;
;***********************
;     DEMO DC-MOTOR    *
;      EXPERIMENT 4    *
;***********************
;
         CPU  "8085.TBL"
         HOF  "INT8"
;

         ORG  2100H

MOT_ON:  EQU  10100000B
MOT_OFF: EQU  00100000B
CTRL:    EQU  0B7H
P_MOT:   EQU  0B6H
DISPY:   EQU  2076H
SYSCAL:  EQU  2
PRINT:   EQU  0CH
SYSFAG:  EQU  208CH
SCAN:    EQU  2
SCANK:   EQU  5
KEYIN:   EQU  208AH
K_FUNC:  EQU  10H
K_RUN:   EQU  12H
K_DEC:   EQU  11H
K_INC:   EQU  13H
BUF:     EQU  207EH
CLEAR:   EQU  3
UNPK:    EQU  7
DIGIT:   EQU  2
KEY:     EQU  2
;
;
START:   MVI  A,10010011B
         OUT  CTRL
         LDA  SYSFAG         ;not instant key
         ORI  00010000B
         STA  SYSFAG
         MVI  A,50H          ;initial on off = 50%
         STA  SPD_ON
         STA  SPD_OFF
;
;/* Display program mode */

         LXI  D,TAB_PRG
         MVI  B,20H
         MVI  C,6
         MVI  A,PRINT
         RST  SYSCAL
;
;/* check key RUN,FUNC */

START1:  MVI  A,SCAN
         RST  SYSCAL
;
         CPI  K_FUNC
         JZ   PRG            ;goto program pluse
         CPI  K_RUN
         JZ   RUN            ;motor run
         JMP  START1
;
;***********************
;       MOTOR RUN      *
;***********************

RUN:     LHLD SPD_ON         ;load speed on off motor
         PUSH H
         POP  B              ;load to BC

         MVI  A,MOT_ON       ;motor on SPEED TO REG C
         OUT  P_MOT
RUN1:    CALL DEL_1MS
         DCR  C
         JNZ  RUN1

         MVI  A,MOT_OFF      ;motor off SPEED TO REG B
         OUT  P_MOT
RUN2:    CALL DEL_1MS
         DCR  B
         JNZ  RUN2
;
;/* check key func */

         MVI  A,4            ;set digit
         OUT  DIGIT
         IN   KEY            ;read key
         ANI  00010000B      ;key func is press
         JNZ  RUN            ;no goto run loop
;
;/* check key func release */

RUN3:    IN   DIGIT
         ANI  00010000B
         JZ   RUN3
         JMP  PRG            ;yes release goto program pluse
;
;***********************
;     PROGRAM PLUSE    *
;***********************

PRG:     LHLD SPD_ON         ;change data speed on off to segment code
         SHLD BUF
         MVI  A,UNPK
         RST  SYSCAL
;
         LHLD DISPY+2        ;save segment on pluse to buffer
         SHLD SEG_ON
         LHLD DISPY          ;save segment off pluse to buffer
         SHLD SEG_OFF

         MVI  A,CLEAR        ;clear display
         RST  SYSCAL
         MVI  A,76H          ;H
         STA  DISPY
         MVI  A,38H          ;L
         STA  DISPY+3
         LHLD SEG_ON         ;load pluse on to display
         SHLD DISPY+1
         LHLD SEG_OFF        ;load pluse off to display
         SHLD DISPY+4
;
         MVI  A,SCAN         ;scan key board and display
         RST  SYSCAL
         CPI  K_DEC
         JZ   PRG_DEC
         CPI  K_INC
         JZ   PRG_INC
         CPI  K_RUN
         JZ   RUN
         JMP  PRG
;
;***********************
;      DEC SPEED ON    *
;***********************

PRG_DEC: LDA  SPD_ON
         SUI  1
         CALL SUB_DAA
         CPI  0
         JZ   PRG_DE1
         STA  SPD_ON
         LDA  SPD_OFF
         ADI  1
         DAA
         STA  SPD_OFF
PRG_DE1: JMP  PRG
;
;***********************
;      INC SPEED OFF   *
;***********************

PRG_INC: LDA  SPD_ON
         ADI  1
         DAA
         CPI  0
         JZ   PRG_IN1
         STA  SPD_ON
         LDA  SPD_OFF
         SUI  1
         CALL SUB_DAA
         STA  SPD_OFF
PRG_IN1: JMP  PRG
;
;***********************
;       SPEED 1 MS     *
;***********************

DEL_1MS: LXI  H,160
DEL_1:   DCX  H
         MOV  A,H
         ORA  L
         JNZ  DEL_1
         RET
;
;***********************
;        SUB-DAA       *
;***********************
;
SUB_DAA: PUSH B
         MOV  B,A
         ANI  0FH
         CPI  0AH
         MOV  A,B
         JC   SUB_D1
         SBI  6
SUB_D1:  MOV  B,A
         ANI  0F0H
         CPI  0A0H
         MOV  A,B
         JC   SUB_D2
         SBI  60H
SUB_D2:  POP  B
         RET


;/* display PROG-M */

TAB_PRG: DFB  73H,50H,5CH,3DH,40H,37H

         ORG  3000H
SPD_ON:  DFS  1
SPD_OFF: DFS  1
SEG_ON:  DFS  2
SEG_OFF: DFS  2
         END
